#! /usr/bin/env python3

import ogonek



# Loop file, only keeping lines between indicators...
lines = []
record = False

with open('20,000 Leagues Under the Seas.txt', 'r') as fin:
  for line in fin:
    if record:
      if line.startswith('***END OF THE PROJECT GUTENBERG'):
        break
      
      lines.append(line)
    
    else:
      if line.startswith('***START OF THE PROJECT GUTENBERG'):
        record = True

text = ''.join(lines)



# Tokenise...
toks = ogonek.Tokenise(text)



# Loop and print sentences...
for i, sentence in enumerate(toks):
  print('{}:'.format(i))
  print('|'.join(sentence))
